#include <liqbase/liqbase.h>
#include <liqbase/liqcell.h>
#include <liqbase/liqcell_easyrun.h>
#include <liqbase/liqcell_easyhandler.h>
#include <liqbase/liqapp_prefs.h>
#include <liqbase/vgraph.h>
#include "liqdoc.h"

#include "liqbookprogress.h"

//#####################################################################
//#####################################################################
//##################################################################### liqbookreader :: by gary birkett
//#####################################################################
//#####################################################################

	static int liqbookreader_paint(liqcell *self, liqcellpainteventargs *args, struct doc *doc)
	{
		
		
		// the body contains the offset we need to render at
		// uber render, GOGOGO!
		liqcell *body = liqcell_child_lookup(self, "body");
		
		//if( -liqcell_gety(body) + liqcell_geth(body)   )
		
		liqcell_setpos(body, liqcell_getx(body)-10,liqcell_getx(body) );
		
		//doc.renderfont=font;
		//args->graph
		//int		vgraph_setfont(        			vgraph *self, liqfont *font);			//  char *fontname, int fontsize, int fontattributes
		//int		vgraph_setpencolor(    			vgraph *self, vcolor pencolor );
		//int		vgraph_drawtext(       			vgraph *self, int x, int y, char *text        );
		vgraph_setfont(args->graph,      doc->renderfont);
		vgraph_setpencolor( args->graph, vcolor_YUV(255,128,128) );
		struct docline *dline = doc->linefirst;
		int y=0;
		int h=0;
		int vt = -liqcell_getx(body);
		int vb = vt + liqcell_getw(self);
		int tmp=0;
		while(dline)
		{
			h=dline->formath;
			//liqapp_log("huh %d %d,  vt=%d vb=%d",y,h,vt,vb);
			if(y+h > vt)
			{
				//liqapp_log("tmp %d",tmp);
				vgraph_drawtext(args->graph, y-vt, 0,dline->linedata  );
				if(y>vb) break;
			}
			tmp++;
			
			y+=h;
			dline=dline->linknext;
		}
		
		
		liqimage *img = liqimage_newatsize(480,800,0);
		
		
		
		
		
		liqcell_setdirty(self,1);
		return 1;
	}


int liqbookreader_run(char *bookfilename)
{
	liqcell *self = liqcell_quickcreatewidget("liqbookreader","form", 800,480);

	if(self)
	{
		int err=0;
		
		//char *bookfilename = liqcell_propgets(self,"bookfilename",NULL);
		
		//================================================== get and process the fontsize
		int edfontsize;
		char * t=NULL;
		if((t=liqapp_pref_getvalue("book_fontsize")))
		{
			edfontsize=atoi(t);
		}
		else
		{
			edfontsize=24;
		}
		
		if(edfontsize<8)edfontsize=8;
		if(edfontsize>72)edfontsize=72;
		edfontsize=20;
		
		//=================================================== now, open the font
		
		liqfont *font = liqfont_cache_getttf("/usr/share/fonts/nokia/nosnb.ttf", (edfontsize), 0);


		if(!font)
		{
			{ return liqapp_warnandcontinue(-1,"liqbookreader_run couldnt open font"); }						
		}			




		//=================================================== initialize the bookprogress

		liqbookprogress_shutdown();
		liqbookprogress_startup();






		//=================================================== open the book now 

		// grab the file and process it :)
		struct doc doc;
		doc.renderfont=NULL;
		
		
		doc.renderfont=font;
		doc.rendermarginright=480;
		//doc.rendermarginbottom=99999999;
	


		err=doc_initfromfilename(&doc,bookfilename);
		
		
		if(err)
		{
			{ return liqapp_warnandcontinue(-1,"liqbookreader_run couldnt open doc"); }						
		}
			
		
	//	// change to rotated now we have weighed it
	//	liqfont_release(font);
	//	font = liqfont_cache_getttf("/usr/share/fonts/nokia/nosnb.ttf", (edfontsize), 90);
	//	doc.renderfont=font;
		
		
		liqcell *body = liqcell_quickcreatevis("body",NULL,0 ,0, doc.rendertoth,480  );
		liqcell_handleradd(body,    "mouse",   liqcell_easyhandler_kinetic_mouse );
		liqcell_child_insert( self, body );
		
		
		//liqcell_handleradd_withcontext(body,    "paint", widget_paint,self);
		
		
		int sfl=0;
		int sfu=0;
		if(liqbookprogress_startreading_lookupposition(bookfilename,&sfl,&sfu))
		{
			//
		}
		
		
		// now, create the booklines or generate on the fly...
	
		//########################################## simple style..
		/*
		struct docline *dline = doc.linefirst;
		int y=0;
		while(dline)
		{

			// no paragraph grouping, very slow for >10k lines (normal book size)
			liqcell *scrline = liqcell_quickcreatevis(dline->linedata,NULL,0 ,y,   800,dline->formath);
			liqcell_setfont(scrline,liqfont_hold(font));
			liqcell_child_insert( body, scrline );
						
			
			y+=dline->formath;
			dline=dline->linknext;
			
		}
		liqapp_log("liqbookreader added %d lines",doc.linecount);
		*/
		
		//########################################## custom renderer ..
		
		liqcell_handleradd_withcontext(self,    "paint", liqbookreader_paint,   &doc);

		liqcell_easyrun(self);
	}
	
	
	liqcell_release(self);
	return 0;
	//return self;
}
